package org.example.driver;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static org.junit.Assert.*;

public class ParserTest extends TestCase {
    @Test
    public void testValidInput() {
        ArrayList<String> args = new ArrayList<>();
        args.add("192.168.0.1");
        args.add("8080");

        try {
            List<Target> targets = null;
            try {
                targets = Parser.run(args);
            } catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals(1, targets.size());
            Target target = targets.get(0);
            Assert.assertEquals("192.168.0.1", target.targetIP);
            Assert.assertArrayEquals(new int[]{8080, 8080}, target.portRange);
        } catch (InvalidUserInputException e) {
            Assert.fail("Unexpected exception occurred: " + e.getMessage());
        }
    }
    @Test
    public void testInvalidInputIP() {
        ArrayList<String> args = new ArrayList<>();
        args.add("15.15.12");
        args.add("600");

        try {
            Parser.run(args);
            Assert.fail("Expected InvalidUserInputException was not thrown.");
        } catch (InvalidUserInputException e) {
            Assert.assertEquals("Invalid user input: ip", e.getMessage());
        } catch (UnknownHostException e) {
            Assert.fail("Unexpected UnknownHostException occurred: " + e.getMessage());
        }
    }
    @Test
    public void testInvalidInputPort() {
        ArrayList<String> args = new ArrayList<>();
        args.add("192.168.12.1");
        args.add("600000");

        try {
            Parser.run(args);
            Assert.fail("Expected InvalidUserInputException was not thrown.");
        } catch (InvalidUserInputException e) {
            Assert.assertEquals("Invalid user input: port", e.getMessage());
        } catch (UnknownHostException e) {
            Assert.fail("Unexpected UnknownHostException occurred: " + e.getMessage());
        }
    }
    @Test
    public void testRangeInput() {
        ArrayList<String> args = new ArrayList<>();
        args.add("192.168.0.1-192.168.0.5");
        args.add("8080-8090");

        try {
            List<Target> targets = Parser.run(args);
            Assert.assertEquals(5, targets.size());
            Target firstTarget = targets.get(0);
            Target lastTarget = targets.get(4);
            Assert.assertEquals("192.168.0.1", firstTarget.targetIP);
            Assert.assertEquals("192.168.0.5", lastTarget.targetIP);
            Assert.assertArrayEquals(new int[]{8080, 8090}, firstTarget.portRange);
            Assert.assertArrayEquals(new int[]{8080, 8090}, lastTarget.portRange);
        } catch (InvalidUserInputException | UnknownHostException e) {
            Assert.fail("Unexpected exception occurred: " + e.getMessage());
        }
    }

}