package org.example.scanner;


import java.util.ArrayList;
import java.util.List;

public final class PortScannerResult {
    private  String targetIP;
    private List<PortStatus> openList;
    private List<PortStatus> closedList;

    public String getTargetIP() {
        return targetIP;
    }

    public void setTargetIP(String targetIP) {
        this.targetIP = targetIP;
    }

    public PortScannerResult(List<PortStatus> resultList, String ip) {
        this.targetIP =ip;
        this.openList = new ArrayList<>();
        this.closedList = new ArrayList<>();

        for (PortStatus eachPortStatus : resultList) {
            if (eachPortStatus.getIsOpen()) {
                openList.add(eachPortStatus);
            } else {
                closedList.add(eachPortStatus);
            }
        }
    }

    @Override
    public String toString() {

        StringBuilder sb = new StringBuilder();
        int totalCount = openList.size() + closedList.size();
        sb.append(openList.size() + "/" + totalCount + " were open\n");

        for (PortStatus openPortStatus : openList) {
            sb.append(openPortStatus + "\n");
        }
        return "Target ip is : "+this.targetIP+"\n"+sb.toString();
    }
}
