package org.example.scanner;

public final class PortStatus {
    private String targetIp;
    private int portNum;
    private boolean isOpen;

    public PortStatus(int portNum, boolean isOpen, String targetIp) {
        this.portNum = portNum;
        this.isOpen = isOpen;
        this.targetIp = targetIp;
    }

    public String getTargetIp() {
        return targetIp;
    }

    public void setTargetIp(String targetIp) {
        this.targetIp = targetIp;
    }

    public int getPortNum() {
        return this.portNum;
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    @Override
    public String toString() {
        String status = "closed";
        if (isOpen) {
            status = "open";
        }
        return portNum + ":\t" + status;
    }

    public void setPortNum(int portNum) {
        this.portNum = portNum;
    }
}

