/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.validation;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.lognet.springboot.grpc.FailureHandlingSupport;
import org.lognet.springboot.grpc.MessageBlockingServerCallListener;
import org.lognet.springboot.grpc.recovery.GRpcRuntimeExceptionWrapper;
import org.lognet.springboot.grpc.validation.group.RequestMessage;
import org.lognet.springboot.grpc.validation.group.ResponseMessage;
import org.springframework.core.Ordered;

public class ValidatingInterceptor
implements ServerInterceptor,
Ordered {
    private final Validator validator;
    private Integer order;
    private final FailureHandlingSupport failureHandlingSupport;

    public ValidatingInterceptor(Validator validator, FailureHandlingSupport failureHandlingSupport) {
        this.validator = validator;
        this.failureHandlingSupport = failureHandlingSupport;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final ForwardingServerCall.SimpleForwardingServerCall validationServerCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendMessage(RespT message) {
                Set violations = ValidatingInterceptor.this.validator.validate(message, new Class[]{ResponseMessage.class});
                if (!violations.isEmpty()) {
                    GRpcRuntimeExceptionWrapper exception = new GRpcRuntimeExceptionWrapper((Throwable)new ConstraintViolationException(violations), Status.FAILED_PRECONDITION);
                    ValidatingInterceptor.this.failureHandlingSupport.closeCall(exception, (ServerCall<?, ?>)this, headers, b -> b.response(message));
                } else {
                    super.sendMessage(message);
                }
            }
        };
        ServerCall.Listener listener = next.startCall((ServerCall)validationServerCall, headers);
        return new MessageBlockingServerCallListener<ReqT>(listener){

            public void onMessage(ReqT message) {
                Set violations = ValidatingInterceptor.this.validator.validate(message, new Class[]{RequestMessage.class});
                if (!violations.isEmpty()) {
                    this.blockMessage();
                    GRpcRuntimeExceptionWrapper exception = new GRpcRuntimeExceptionWrapper((Throwable)new ConstraintViolationException(violations), Status.INVALID_ARGUMENT);
                    ValidatingInterceptor.this.failureHandlingSupport.closeCall(exception, (ServerCall<?, ?>)validationServerCall, headers, b -> b.request(message));
                } else {
                    super.onMessage(message);
                }
            }
        };
    }

    public int getOrder() {
        return Optional.ofNullable(this.order).orElse(-2147483638);
    }

    public ValidatingInterceptor order(Integer order) {
        this.order = order;
        return this;
    }
}

