function submitSearch() {

    var searchQuery = document.getElementById("searchInput").value;
    if (searchQuery === '') {
        var resultDiv = document.getElementById("result");
        resultDiv.innerHTML = "<p class='error-item'>Please enter a search query.</p>";

    } else {
        var xhr = new XMLHttpRequest();
        xhr.open("POST", "http://localhost:8081/Proxy/searchServlet", true);
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.onload = function() {
            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                displayResults(response);
            } else {
                alert("Error: " + xhr.status);
                var resultDiv = document.getElementById("result");
                resultDiv.innerHTML = "<p class='error-item'>there is an error, try later !</p>";
            }
        };
        var jsonData = JSON.stringify({ query: searchQuery });
        xhr.send(jsonData);
    };


    // Convert the search query to a JSON string
    var jsonData = JSON.stringify({ query: searchQuery });

    // Send the request with the JSON data
    xhr.send(jsonData);
}

function displayResults(response) {
    var resultDiv = document.getElementById("result");
    resultDiv.innerHTML = "";

    if (Object.keys(response).length === 0) {
        var noResultElement = document.createElement("p");
        noResultElement.className = "no-result-item";
        noResultElement.textContent = "service not available, try later !!";
        resultDiv.appendChild(noResultElement);
    } else {
        for (var key in response) {
            var value = response[key];
            var resultElement = document.createElement("p");
            resultElement.className = "result-item";
            resultElement.textContent = "Document: " + key + ", Score: " + value;
            resultDiv.appendChild(resultElement);
        }
    }
}