/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.lognet.springboot.grpc.FailureHandlingSupport;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcServerBuilderConfigurer;
import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.GRpcServicesRegistry;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.GRpcValidationConfiguration;
import org.lognet.springboot.grpc.autoconfigure.NettyServerBuilderSelector;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.lognet.springboot.grpc.health.DefaultHealthStatusService;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandlerInterceptor;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandlerMethodResolver;
import org.lognet.springboot.grpc.recovery.GRpcServiceAdvice;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.SocketUtils;

@AutoConfigureOrder
@AutoConfigureAfter(value={ValidationAutoConfiguration.class})
@ConditionalOnBean(annotation={GRpcService.class})
@Import(value={GRpcValidationConfiguration.class, NettyServerBuilderSelector.class, DefaultHealthStatusService.class})
@Configuration
public class GRpcAutoConfiguration {
    @Bean
    @OnGrpcServerEnabled
    public GRpcServerRunner grpcServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator, ServerBuilder<?> serverBuilder) {
        return new GRpcServerRunner(configurator, serverBuilder);
    }

    @Bean
    @ConditionalOnProperty(prefix="grpc", name={"inProcessServerName"})
    public GRpcServerRunner grpcInprocessServerRunner(@Qualifier(value="grpcInternalConfigurator") Consumer<ServerBuilder<?>> configurator, GRpcServerProperties gRpcServerProperties) {
        return new GRpcServerRunner(configurator, (ServerBuilder<?>)InProcessServerBuilder.forName((String)gRpcServerProperties.getInProcessServerName()));
    }

    @Bean
    public GRpcServicesRegistry grpcServicesRegistry() {
        return new GRpcServicesRegistry();
    }

    @Bean
    public GRpcExceptionHandlerMethodResolver exceptionHandlerMethodResolver(GRpcServicesRegistry gRpcServicesRegistry, ApplicationContext applicationContext) {
        Collection<Object> advices = applicationContext.getBeansWithAnnotation(GRpcServiceAdvice.class).values();
        return new GRpcExceptionHandlerMethodResolver(gRpcServicesRegistry, advices);
    }

    @Bean
    public FailureHandlingSupport failureHandlingSupport(GRpcExceptionHandlerMethodResolver methodResolver) {
        return new FailureHandlingSupport(methodResolver);
    }

    @Bean
    @GRpcGlobalInterceptor
    public GRpcExceptionHandlerInterceptor exceptionHandlerInterceptor(FailureHandlingSupport failureHandlingSupport, GRpcExceptionHandlerMethodResolver methodResolver, GRpcServerProperties serverProperties) {
        return new GRpcExceptionHandlerInterceptor(methodResolver, failureHandlingSupport, serverProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={GRpcServerBuilderConfigurer.class})
    public GRpcServerBuilderConfigurer serverBuilderConfigurer() {
        return new GRpcServerBuilderConfigurer();
    }

    @Bean
    public GRpcServerProperties gRpcServerProperties() {
        return new GRpcServerProperties();
    }

    @ConditionalOnMissingClass(value={"org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties"})
    @Bean
    public ConfigurationPropertiesBindHandlerAdvisor skipConsulDiscoveryBinding() {
        return bindHandler -> new AbstractBindHandler(bindHandler){
            private final ConfigurationPropertyName grpcConsulConfigProperty;
            {
                this.grpcConsulConfigProperty = ConfigurationPropertyName.of((CharSequence)"grpc.consul");
            }

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                return this.grpcConsulConfigProperty.equals((Object)name) ? null : super.onStart(name, target, context);
            }
        };
    }

    @Bean(name={"grpcInternalConfigurator"})
    public Consumer<ServerBuilder<?>> configurator(GRpcServerBuilderConfigurer configurer, GRpcServerProperties grpcServerProperties) {
        return serverBuilder -> {
            if (grpcServerProperties.isEnabled()) {
                Optional.ofNullable(grpcServerProperties.getSecurity()).ifPresent(s -> {
                    boolean setupSecurity = Optional.ofNullable(s.getCertChain()).isPresent();
                    if (setupSecurity != Optional.ofNullable(s.getPrivateKey()).isPresent()) {
                        throw new BeanCreationException("Both  gRPC  TLS 'certChain' and 'privateKey' should be configured. One of them is null. ");
                    }
                    if (setupSecurity) {
                        try {
                            serverBuilder.useTransportSecurity(s.getCertChain().getInputStream(), s.getPrivateKey().getInputStream());
                        }
                        catch (IOException e) {
                            throw new BeanCreationException("Failed to setup security", (Throwable)e);
                        }
                    }
                });
            }
            configurer.configure((ServerBuilder<?>)serverBuilder);
        };
    }

    @Bean
    @ConfigurationPropertiesBinding
    public static Converter<String, InetSocketAddress> socketAddressConverter() {
        return new Converter<String, InetSocketAddress>(){

            public InetSocketAddress convert(String source) {
                int port;
                String[] chunks = source.split(":");
                switch (chunks.length) {
                    case 1: {
                        port = 6565;
                        break;
                    }
                    case 2: {
                        port = Integer.parseInt(chunks[1]);
                        if (port >= 1) break;
                        port = SocketUtils.findAvailableTcpPort();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(source + " can't be converted to socket address");
                    }
                }
                return new InetSocketAddress(chunks[0], port);
            }
        };
    }
}

