package Proxy;


import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class SearchProxy implements Watcher{

    private static final Logger logger = LoggerFactory.getLogger(SearchProxy.class);
    private static final String address = "192.168.181.136:2181";
    private static final String coordinatorAddress = "";
    private static final String COORDINATOR_ZNODE = "/cordinator";
    private static final int SESSION_TIMEOUT = 3000; //dead client
    private static final int DEFAULT_PORT = 8080;
    private static String CURRENT_COORDINATOR = "";
    private static String CURRENT_COORDINATOR_FULL_PATH = "";
    private ZooKeeper zooKeeper;

    public  String getCurrentCoordinator() {
        return CURRENT_COORDINATOR;
    }

    public  void setCurrentCoordinator(String currentCoordinator) {
        CURRENT_COORDINATOR = currentCoordinator;
    }

    public static String getCurrentCoordinatorFullPath() {
        return CURRENT_COORDINATOR_FULL_PATH;
    }

    public static void setCurrentCoordinatorFullPath(String currentCoordinatorFullPath) {
        CURRENT_COORDINATOR_FULL_PATH = currentCoordinatorFullPath;
    }

    public ZooKeeper getZooKeeper() {
        return zooKeeper;
    }

    public void setZooKeeper(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public  Map<String,Double> searchOnCoordinator(String searchQuery) throws InterruptedException, IOException {
            ManagedChannel channel = ManagedChannelBuilder.forAddress(CURRENT_COORDINATOR, 6565).usePlaintext().build();
            SearchServiceGrpc.SearchServiceBlockingStub searchServiceBlockingStub = SearchServiceGrpc.newBlockingStub(channel);
            SearchResponse searchResponse = searchServiceBlockingStub.search(Proxy.SearchRequest.newBuilder().setQuery(searchQuery).build());
            Proxy.SearchResult searchResult = searchResponse.getSearchResult();
            Map<String,Double> response = searchResult.getResultsMap();
            if(response.isEmpty() || response == null){
                logger.warn("No results, maybe cluster does not have workers !!");
                response = null;
            }
            else {
                logger.info("Results is:");
                for (Map.Entry<String, Double> entry : response.entrySet())
                {
                    String documentName = entry.getKey();
                    Double score = entry.getValue();
                    logger.info("Document name: "+ documentName+ " , Score: "+score);
                }
            }
            return response;
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(address, SESSION_TIMEOUT, this);
        return zooKeeper;
    }

    public void run() throws InterruptedException {
        synchronized (zooKeeper) {
            zooKeeper.wait();
        }
    }

    public void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None:
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    logger.debug("Successfully connected to Zookeeper");
                } else if (watchedEvent.getState() == Watcher.Event.KeeperState.Disconnected) {
                    synchronized (zooKeeper) {
                        logger.debug("Disconnected from Zookeeper");
                        zooKeeper.notifyAll();
                    }
                } else if (watchedEvent.getState() == Watcher.Event.KeeperState.Closed) {
                    logger.debug("Closed Successfully");
                }
                break;
            case NodeDeleted:
                System.out.println("change");
                if(watchedEvent.getPath().equals(CURRENT_COORDINATOR_FULL_PATH)){
                    getCoordinatorAddress();
                }
                break;
        }
    }
    public void getCoordinatorAddress(){
        try {
            Thread.sleep(10000);
            List<String> children = zooKeeper.getChildren(COORDINATOR_ZNODE, false);
            if(children.size() == 1){
                String coordinatorZnode = children.get(0);
                CURRENT_COORDINATOR_FULL_PATH = COORDINATOR_ZNODE + "/" + coordinatorZnode;
                Stat stat = zooKeeper.exists(CURRENT_COORDINATOR_FULL_PATH, this);
                if (stat == null) {
                    System.out.println("Coordinator not found !");
                    logger.warn("Coordinator not found !");
                }else {

                    byte[] addressBytes = zooKeeper.getData(CURRENT_COORDINATOR_FULL_PATH, false, stat);
                    String address = new String(addressBytes);
                    CURRENT_COORDINATOR = address;
                    System.out.println("full path: "+ CURRENT_COORDINATOR_FULL_PATH+" , address: "+ CURRENT_COORDINATOR);
                }
            } else if (children.size() > 1) {
                System.out.println("there are more than coordinator !!");
                logger.warn("there are more than coordinator !!");
            }else {
                System.out.println("coordinator not available !!");
                logger.warn("coordinator not available !!");
            }
        } catch (KeeperException e) {
            throw new RuntimeException("Coordinator is down !!! ");
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

    }
}