package Proxy;

import Proxy.SearchProxy;
import com.google.gson.Gson;
import org.apache.zookeeper.ZooKeeper;
import org.json.JSONException;
import org.json.JSONObject;

import Proxy.SearchProxy;
import com.google.gson.Gson;
import org.apache.zookeeper.ZooKeeper;
import org.json.JSONException;
import org.json.JSONObject;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class SearchServlet extends HttpServlet {
    private SearchProxy searchProxy = new SearchProxy();
    private static final Logger logger = LoggerFactory.getLogger(SearchServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        // Read the JSON data from the request
        StringBuilder jsonStringBuilder = new StringBuilder();
        String line;
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            jsonStringBuilder.append(line);
        }
        String jsonString = jsonStringBuilder.toString();

        // Parse the JSON data
        String searchQuery = ""; // Default value
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            searchQuery = jsonObject.getString("query");
            logger.info("New search request for: "+searchQuery);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        // Perform your logic to generate the response
        Map<String, Double> searchResults = null;
        try {
            searchResults = performSearch(searchQuery);
            if(searchResults.isEmpty() || searchResults == null){
                logger.info("no results, maybe does not exist workers !!");
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // Convert the search results to a JSON string
        String jsonResponse = new Gson().toJson(searchResults);

        // Set CORS headers
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type");

        // Send the JSON response back to the client
        response.setContentType("application/json");
        response.getWriter().write(jsonResponse);
    }

    private Map<String, Double> performSearch(String query) throws IOException, InterruptedException {
        Map<String,Double> response = new HashMap<>();
        ZooKeeper zooKeeper = searchProxy.connectToZookeeper();
        searchProxy.setZooKeeper(zooKeeper);
        searchProxy.getCoordinatorAddress();
        if(!searchProxy.getCurrentCoordinator().isEmpty() && !searchProxy.getCurrentCoordinator().equals("")){
           response = searchProxy.searchOnCoordinator(query);
        }
        return response;
    }
    protected void doOptions(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type");
        response.setStatus(HttpServletResponse.SC_OK);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        // Forward the request to the index.html file
        RequestDispatcher dispatcher = request.getRequestDispatcher("wepapp/index.html");
        dispatcher.forward(request, response);
    }
}