import com.mongodb.client.*;
import org.apache.commons.lang3.RandomStringUtils;
import org.bson.Document;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UsersGenerator {

    private static final String MONGOS_URL = "mongodb://192.168.181.136:27046";
    private static final String DB_NAME = "MoviesDB";
    private static final String COLLECTION_NAME = "users";

    private static final Random random = new Random();

    public static void main(String[] args) {
        MongoDatabase MoviesDB = connectToMongos(DB_NAME);
        generateUsers(10000, MoviesDB, COLLECTION_NAME);

    }
    private static MongoDatabase connectToMongos(String dbName) {
        MongoClient mongoClient = MongoClients.create(MONGOS_URL);
        return mongoClient.getDatabase(dbName);
    }

    private static void generateUsers(int numberOfUsers, MongoDatabase database, String collectionName) {
        MongoCollection<Document> collection = database.getCollection(collectionName);

        List<Document> documents = new ArrayList<>();
        System.out.println("Generating " + numberOfUsers + " user");
        for (int userIndex = 0; userIndex < numberOfUsers; userIndex++) {
            Document document = new Document();
            document.append("user_name", generateUserName())
                    .append("watched_movies", generateWatchedMovies())
                    .append("subscription_month", generateSubscriptionMonth());
            documents.add(document);
        }

        collection.insertMany(documents);

        System.out.println("Finished generating users");
    }



    private static String generateUserName() {
        return RandomStringUtils.randomAlphabetic(10);
    }

    private static List<String> generateWatchedMovies() {
        int numberOfMovies = random.nextInt(4) + 1;
        List<String> movies = new ArrayList<>(numberOfMovies);

        for (int i = 0; i < numberOfMovies; i++) {
            movies.add("Movie " + (i + 1));
        }

        return movies;
    }

    private static String generateSubscriptionMonth() {
        int month = random.nextInt(12) + 1;
        int year = random.nextInt(10) + 2015;
        return String.format("%02d-%04d", month, year);
    }
}