package SharedInterface;

import Data.Result;
import Data.User;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

public interface ChatInterface extends Remote {
    Result addChatRoom(String roomName, User owner) throws RemoteException;
    Result deleteChatRoom(String roomName, User owner) throws RemoteException;
    Result registerUser(String userName, String password, String firstName, String secondName) throws RemoteException;
    Result loginToSystem(String userName, String password) throws RemoteException;

    Result login(String userName, String password, String roomName) throws RemoteException;
    Result logout(String userName, String roomName) throws RemoteException;
    List<String> getAvailableChatRooms() throws RemoteException;
    List<String> getClientsInChatRoom() throws RemoteException;
    void sendMessageToClient(String sender, String receiver, String message) throws RemoteException;
    void sendMessageToRoom(String sender, String roomName, String message) throws RemoteException;
    User getUserInfo(String username) throws RemoteException;
}
