package org.example;

import SharedInterface.ChatInterface;

import javax.swing.*;
import java.awt.*;

public class ShowRoomsForm extends JDialog{
    private JScrollPane scroll;
    private JPanel ShowPanel;


    public ShowRoomsForm(ChatInterface chatInterface) {
        setTitle("Show all rooms");
        setPreferredSize(new Dimension(450, 474));  // Set the preferred size for the ShowPanel

        ShowPanel = new JPanel();
        ShowPanel.setLayout(new BoxLayout(ShowPanel, BoxLayout.Y_AXIS));

        String[] itemList = {"Item 1", "Item 4", "Item 5", "Item 3", "Item 4", "Item 5", "Item 2", "Item 3", "Item 4", "Item 5"};
        for (String item : itemList) {
            ItemPanel itemPanel = new ItemPanel(item);
            ShowPanel.add(itemPanel);
        }

        scroll = new JScrollPane(ShowPanel);
        scroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

        setContentPane(scroll);
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        pack();
        setVisible(true);
    }
//    public ShowRoomsForm(ChatInterface chatInterface){
//        setTitle("Show all rooms");
////        setContentPane(scroll);
////        setMinimumSize(new Dimension(450, 474));
////        setModal(true);
////        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
//        ShowPanel = new JPanel();
//
//        ShowPanel.setLayout(new BoxLayout(ShowPanel, BoxLayout.Y_AXIS));
//        scroll = new JScrollPane(ShowPanel);
//
//        setContentPane(scroll);
//        setMinimumSize(new Dimension(450, 474));
//        setModal(true);
//        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
//        String[] itemList = {"Item 1", "Item 4", "Item 5", "Item 3", "Item 4", "Item 5", "Item 2", "Item 3", "Item 4", "Item 5"};
//        JPanel itemContainer = new JPanel();
//        itemContainer.setLayout(new BoxLayout(itemContainer, BoxLayout.Y_AXIS));
//        for (String item : itemList) {
//            ItemPanel itemPanel = new ItemPanel(item);
//            itemContainer.add(itemPanel);
//        }
//        scroll.setViewportView(itemContainer);
//        pack();
//        setVisible(true);
//    }
}
