package org.example;

import Data.Result;
import SharedInterface.ChatInterface;
import SharedVariables.SharedVariables;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class LoginForm extends JDialog{
    private JLabel lUserName;
    private JTextField tfUserName;
    private JLabel lPassword;
    private JPasswordField tfPassword;
    private JButton btnOK;
    private JButton btnCancel;
    private JPanel LoginPanel;
    private JLabel lWelcome;
    private JLabel lForm;

    public LoginForm(ChatInterface chatInterface)  {
        setTitle("Enter Your Account");
        setContentPane(LoginPanel);
        setMinimumSize(new Dimension(450, 474));
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        btnOK.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String username = tfUserName.getText();
                String password = String.valueOf(tfPassword.getPassword());
                if(username.isEmpty() || password.isEmpty()){
                    JOptionPane.showMessageDialog(LoginPanel, "please enter all fields"
                            ,"try again", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                try {
                    Result result = new Result();
                    result = chatInterface.loginToSystem(username,password);
                    if(result.isSuccess()){
                        JOptionPane.showMessageDialog(LoginPanel, result.getDescription()
                                ,"Success", JOptionPane.INFORMATION_MESSAGE);
                        SharedVariables.setUser(chatInterface.getUserInfo(username));
                        dispose();
                        HomeForm home = new HomeForm(chatInterface);
//                        home.setVisible(true);

                    }
                    else{
                        JOptionPane.showMessageDialog(LoginPanel, result.getDescription()
                                ,"Failed", JOptionPane.ERROR_MESSAGE);
                    }


                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        btnCancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                DashboardForm dashboard = new DashboardForm(chatInterface);
//                dashboard.setVisible(true);
            }
        });
        setVisible(true);

    }

}
