package org.example;

import SharedInterface.ChatInterface;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class HomeForm extends JDialog {
    private JPanel HomePanel;
    private JLabel lWelcome;
    private JLabel lText;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnShow;
    private JButton btnLogout;

    public HomeForm(ChatInterface chatInterface){
        setTitle("Home");
        setContentPane(HomePanel);
        setMinimumSize(new Dimension(450, 474));
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);


        btnAdd.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                AddRoomForm addRoomForm = new AddRoomForm(chatInterface);

            }
        });
        btnRemove.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                RemoveRoomForm removeRoomForm = new RemoveRoomForm(chatInterface);

            }
        });
        btnShow.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                ShowRoomsForm show = new ShowRoomsForm(chatInterface);

//                SwingUtilities.invokeLater(() -> {
//                    ShowRoomsForm show = new ShowRoomsForm(chatInterface);
//                });

            }
        });
        btnLogout.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

            }
        });
        setVisible(true);
    }

}
