package org.example;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ItemPanel extends JPanel {
    private String itemName;
    private JLabel nameLabel;

    public ItemPanel(String itemName) {
        this.itemName = itemName;
        setLayout(new FlowLayout());

        nameLabel = new JLabel(itemName);
        nameLabel.addMouseListener(new ItemClickListener());
        add(nameLabel);
    }
    private class ItemClickListener extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            // Handle item click event here
            System.out.println(itemName+" is clicked ");
            JOptionPane.showMessageDialog(ItemPanel.this, "Item clicked: " + itemName);
        }
    }
}
