package org.example;
import Data.Result;
import Data.Room;
import Data.User;
import SharedInterface.ChatInterface;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class ChatServiceImpl extends UnicastRemoteObject implements ChatInterface {
    private List<Room> chatRooms;
    private List<User> registeredUsers;
    private List<User> loggedInUsers;

    protected ChatServiceImpl() throws RemoteException {
        super();
        chatRooms = new ArrayList<>();
        registeredUsers = new ArrayList<>();
        loggedInUsers = new ArrayList<>();
    }

    @Override
    public Result addChatRoom(String roomName, User owner) throws RemoteException {
      Result result = new Result();
      for(Room room : chatRooms){
          if(room.getRoomName().equals(roomName)){
              result.setDescription("Chat room "+roomName+" is already exist");
              result.setSuccess(false);
              return result;
          }
      }

        Room room = new Room(roomName,owner);
        room.getUsers().add(owner);
        System.out.println("user: "+owner.getUserName()+" "+owner.getFirstName()+" add chat room named: "+roomName);
        chatRooms.add(room);
        for (Room room1 : chatRooms){
            System.out.println("Room name: "+room1.getRoomName()+" the owner is:" + owner.getUserName());
        }
        result.setDescription("Chat room "+roomName+" is created successfully");
        result.setSuccess(true);
        return result;

    }

    @Override
    public Result deleteChatRoom(String roomName,User owner ) throws RemoteException {
        Result result = new Result();
        for(Room room : chatRooms){
            if(room.getRoomName().equals(roomName)){
                if(room.getOwner().getUserName().equals(owner.getUserName())&&room.getOwner().getPassword().equals(owner.getPassword())){
                    chatRooms.remove(room);
                    result.setDescription("Chat room "+roomName+" is deleted successfully");
                    result.setSuccess(true);
                }
                else{
                    result.setDescription("Permission denied!!!");
                    result.setSuccess(false);
                }
                return result;
            }

        }
        result.setDescription("Chat room "+roomName+" does not exist");
        result.setSuccess(false);
        return result;
    }

    @Override
    public Result registerUser(String userName, String password, String firstName, String secondName) throws RemoteException {
        System.out.println("there is user want to register");
        Result result = new Result();
        for(User user : registeredUsers){
          if(user.getUserName().equals(userName)) {
              result.setSuccess(false);
              result.setDescription("UserName is already exist");
              return result;
          }
        }
        User newuser = new User(userName,firstName,secondName,password);
        registeredUsers.add(newuser);
        result.setSuccess(true);
        result.setDescription("registration done successfully");
        System.out.println("Done");
        for(User user: registeredUsers){
            System.out.println(user.getUserName()+"  "+user.getPassword()+ "  "+user.getFirstName()+"  "+user.getLastName());
        }

        return result;
    }

    @Override
    public Result loginToSystem(String userName, String password) throws RemoteException {
        Result result = new Result();
        for(User user : registeredUsers){
            if(user.getUserName().equals(userName)){
                if(user.getPassword().equals(password)){
                    loggedInUsers.add(user);
                    result.setSuccess(true);
                    result.setDescription("log in done successfully");
                }
                else{
                    result.setSuccess(false);
                    result.setDescription("user name and password does not match !!!");
                }
                return result;
            }
        }
        result.setSuccess(false);
        result.setDescription("user name does not exist");
        return result;
    }

    @Override
    public Result login(String userName, String password, String roomName) throws RemoteException {
       Result result = new Result();

       for(Room room : chatRooms){
           if(room.getRoomName()==roomName){
               for (User user : room.getUsers()){
                   if(user.getUserName() == userName && user.getPassword() == password){
                       result.setDescription("Logged in successfully");
                       result.setSuccess(true);
                       return result;
                   }
               }
               result.setDescription("Permission denied !!!");
               result.setSuccess(false);
               return result;

           }

       }
        result.setDescription("Room name does not exist !!!");
        result.setSuccess(false);
        return result;



    }

    @Override
    public Result logout(String userName, String roomName) throws RemoteException {
        Result result = new Result();

        for(Room room : chatRooms){
            if(room.getRoomName() == roomName){
                for(User user : room.getUsers()){
                    if(user.getUserName() == userName){
                        room.getUsers().remove(user);
                        result.setDescription("logout done successfully");
                        result.setSuccess(true);
                    }
                    else{
                        result.setDescription("User name does not exist in this room !!!");
                        result.setSuccess(false);
                    }
                    return result;
                }

            }
        }
        result.setDescription("Room name does not exist!!!");
        result.setSuccess(false);
        return result;


    }

    @Override
    public List<String> getAvailableChatRooms() throws RemoteException {
        return null;
    }

    @Override
    public List<String> getClientsInChatRoom() throws RemoteException {
        return null;
    }

    @Override
    public void sendMessageToClient(String sender, String receiver, String message) throws RemoteException {

    }

    @Override
    public void sendMessageToRoom(String sender, String roomName, String message) throws RemoteException {

    }

    @Override
    public User getUserInfo(String username) throws RemoteException {
        for (User user : registeredUsers){
            if(user.getUserName().equals(username)){
                return user;
            }
        }
        return null;
    }
}