package org.example;

import Data.Result;
import Data.User;
import SharedInterface.ChatInterface;
import SharedVariables.SharedVariables;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;

public class RemoveRoomForm extends JDialog {
    private JPanel RemovePanel;
    private JLabel lTitle;
    private JLabel lRoomName;
    private JTextField tfRoomName;
    private JButton btnRemove;
    private JButton btnCancel;

    public RemoveRoomForm(ChatInterface chatInterface){
        setTitle("Remove an existed room");
        setContentPane(RemovePanel);
        setMinimumSize(new Dimension(450, 474));
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        btnRemove.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String roomName = tfRoomName.getText();
                if(roomName.isEmpty()){
                    JOptionPane.showMessageDialog(RemovePanel, "please enter room name"
                            ,"Failed", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                try {
                    Result result = new Result();

                    result = chatInterface.deleteChatRoom(roomName, SharedVariables.getUser());
                    if(result.isSuccess()){
                        JOptionPane.showMessageDialog(RemovePanel, result.getDescription()
                                ,"Success", JOptionPane.INFORMATION_MESSAGE);
                        dispose();
                        HomeForm home = new HomeForm(chatInterface);
//                        home.setVisible(true);

                    }
                    else{
                        JOptionPane.showMessageDialog(RemovePanel, result.getDescription()
                                ,"Failed", JOptionPane.ERROR_MESSAGE);
                    }
                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
            }

        });
        btnCancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                HomeForm home = new HomeForm(chatInterface);

            }
        });
        setVisible(true);
    }
}
