package org.example;

import Data.Result;
import Data.User;
import SharedInterface.ChatInterface;
import SharedVariables.SharedVariables;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;

public class AddRoomForm extends JDialog{
    private JPanel AddRoomPanel;
    private JLabel lTitle;
    private JTextField tfRoomName;
    private JLabel lName;
    private JButton btnAdd;
    private JButton btnCancel;

    public AddRoomForm(ChatInterface chatInterface){
        setTitle("Add chat room");
        setContentPane(AddRoomPanel);
        setMinimumSize(new Dimension(450, 474));
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);


        btnAdd.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String roomName = tfRoomName.getText();
                if(roomName.isEmpty()){
                    JOptionPane.showMessageDialog(AddRoomPanel, "please enter room name"
                            ,"Failed", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                try {
                    Result result = new Result();

                    result = chatInterface.addChatRoom(roomName, SharedVariables.user);
                    if(result.isSuccess()){
                        JOptionPane.showMessageDialog(AddRoomPanel, result.getDescription()
                                ,"Success", JOptionPane.INFORMATION_MESSAGE);
                        dispose();
                        HomeForm home = new HomeForm(chatInterface);
//                        home.setVisible(true);

                    }
                    else{
                        JOptionPane.showMessageDialog(AddRoomPanel, result.getDescription()
                                ,"Failed", JOptionPane.ERROR_MESSAGE);
                    }


                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }


            }
        });
        btnCancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                HomeForm home = new HomeForm(chatInterface);
//                home.setVisible(true);

            }
        });
        setVisible(true);

    }

}
