package org.example;

import SharedInterface.ChatInterface;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ItemPanel extends JPanel {
    private static final int PANEL_HEIGHT = 30;
    private String itemName;
    private JLabel nameLabel;

    public ItemPanel(String itemName, ChatInterface chatInterface) {
        this.itemName = itemName;
        setLayout(new BorderLayout());
        setPreferredSize(new Dimension(300, PANEL_HEIGHT));
        nameLabel = new JLabel(itemName);
        nameLabel.setFont(new Font("Arial", Font.BOLD, 18));
        nameLabel.setHorizontalAlignment(SwingConstants.LEFT);
        add(nameLabel, BorderLayout.WEST);
        addMouseListener(new ItemClickListener(chatInterface,itemName));
    }

    private class ItemClickListener extends MouseAdapter {
        ChatInterface chatInterface;
        String roomName;

        public ItemClickListener(ChatInterface chatInterface, String roomName) {
            this.chatInterface = chatInterface;
            this.roomName = roomName;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ShowRoomsForm showRoomsForm = (ShowRoomsForm) SwingUtilities.getWindowAncestor(ItemPanel.this);
            showRoomsForm.dispose();
            ChatRoomForm chatRoomForm = new ChatRoomForm(chatInterface,roomName);
        }
    }
}