package org.example;
import Data.Result;
import Data.User;
import SharedInterface.ChatInterface;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;

public class RegistrationForm extends JDialog {
    private JPasswordField tfPass;
    private JButton btnRegister;
    private JButton btnCancel;
    private JPanel RegisterPanel;
    private JTextField tfLastname;
    private JLabel lLastname;
    private JTextField tfFirstname;
    private JTextField tfUsername;
    private JLabel lUsername;
    private JLabel lFirstname;
    private JLabel lPassword;
    private JLabel lTitle;
//    private JLabel lImage;

    public RegistrationForm(ChatInterface chatInterface){

        setTitle("Create a new account");
        setContentPane(RegisterPanel);
        setMinimumSize(new Dimension(450, 474));
        setModal(true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        btnRegister.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String username = tfUsername.getText();
                String lastname = tfLastname.getText();
                String firstname = tfFirstname.getText();
                String password = String.valueOf(tfPass.getPassword());
                if(username.isEmpty() || lastname.isEmpty() || firstname.isEmpty() || password.isEmpty()){
                    JOptionPane.showMessageDialog(RegisterPanel, "please enter all fields"
                    ,"try again", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                try {
                    Result result = new Result();
                     result = chatInterface.registerUser(username,password,firstname,lastname);
                     if(result.isSuccess()){
                         JOptionPane.showMessageDialog(RegisterPanel, result.getDescription()
                                 ,"Success", JOptionPane.INFORMATION_MESSAGE);
                         dispose();
                         LoginForm login = new LoginForm(chatInterface);
//                         login.setVisible(true);

                     }
                     else{
                         JOptionPane.showMessageDialog(RegisterPanel, result.getDescription()
                                 ,"Success", JOptionPane.ERROR_MESSAGE);
                     }


                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }

            }
        });

        btnCancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                DashboardForm dashboard = new DashboardForm(chatInterface);
//                dashboard.setVisible(true);
            }
        });
        setVisible(true);

    }


}
