import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ThreadPool {

    private  ConcurrentList<Runnable> taskList = null;
    private List<PoolThreadRunnable> runnables = new ArrayList<PoolThreadRunnable>();
    private boolean isStopped = false;

    public ThreadPool(int noOfThreads, int maxNoOfTasks){
        taskList = new ConcurrentList<Runnable>(new ArrayList<Runnable>(maxNoOfTasks),maxNoOfTasks);

        for(int i=0; i<noOfThreads; i++){
            PoolThreadRunnable poolThreadRunnable =
                    new PoolThreadRunnable(taskList);

            runnables.add(poolThreadRunnable);
        }
        for(PoolThreadRunnable runnable : runnables){
            new Thread(runnable).start();

        }
    }

    public synchronized void  execute(Runnable task) throws Exception{
        if(this.isStopped) throw
                new IllegalStateException("ThreadPool is stopped");
        synchronized (taskList){

            this.taskList.add(task);
        }

    }
    public synchronized void stop(){
        this.isStopped = true;
        for(PoolThreadRunnable runnable : runnables){
            runnable.doStop();
        }
    }

    public synchronized void waitUntilAllTasksFinished() {
        while(this.taskList.size() > 0) {
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
               e.printStackTrace();
            }
        }
    }




}
