import java.util.List;
import java.util.concurrent.BlockingQueue;

public class PoolThreadRunnable implements Runnable{

    private Thread        thread    = null;
    private  ConcurrentList<Runnable> taskList = null;
    private boolean       isStopped = false;

    public PoolThreadRunnable(ConcurrentList<Runnable> queue){
        taskList = queue;
    }

    public void run(){
        this.thread = Thread.currentThread();
        while(!isStopped()) {
            try {
                synchronized (taskList){
                    Runnable task =taskList.take();
                    task.run();
                }

            } catch (Exception e) {
            }

        }

    }

    public synchronized void doStop(){
        isStopped = true;
        //break pool thread out of dequeue() call.
        this.thread.interrupt();
    }

    public synchronized boolean isStopped(){
        return isStopped;
    }

}


