import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentList<E> {
    private List<E> ls;
    private final Object IS_NOT_FULL = new Object();
    private final Object IS_NOT_EMPTY = new Object();
    private final int max;
    public ConcurrentList(List<E> ls,int max){
        this.ls=ls;
        this.max=max;
    }

    public  E take() throws InterruptedException {
            while (ls.size()==0){
                wait();
            }
            E task=ls.remove(0);
                notify();
                return task;
    }

    public   void add(E item) throws InterruptedException {
        while(isFull()){
            wait();
        }
         ls.add(item);
         notify();
    }
    public synchronized  int size() {
        return ls.size();
    }


    public boolean isFull() throws InterruptedException {
        return ls.size()==max;
    }
}
