#include <stdio.h>
#include <omp.h>

#define N 100000000 // Number of rectangles for the approximation

double calculate_partial_area(double x, double width) {
    double height = x * x;
    return width * height;
}

int main() {
    double total_area = 0.0;
    double width = 1.0 / N;
    
    #pragma omp parallel for reduction(+:total_area)
    for (int i = 0; i < N; ++i) {
        double x = (i + 0.5) * width; // Midpoint of the rectangle
        total_area += calculate_partial_area(x, width);
    }

    printf("Numerical integration using OpenMP:\n");
    printf("Total area under the curve (X^2) for %d rectangles: %f\n", N, total_area);


    return 0;
}
 
