package org.example;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;
//import PortScanner;
import java.net.UnknownHostException;
import java.net.InetAddress;

public class Main{
    private static final int SCAN_TIMEOUT = 200;
    private static final int THREAD_COUNT = 128;
    public static void main(String[] args) {

        // get a Target info from Parser
        Target t = null;
        try {
            String[] ar={"64.233.185.138-64.233.185.140","80-84"};
            t = Parser.run(ar);
        } catch (InvalidUserInputException e) {
            // exit with the message
            System.err.println(e.getMessage());
            System.exit(1);
        }



        // run a scan on the target and get a result
        System.out.println("Scanning ports for every IP from " + t.targetIP + " to " + t.targetIPEnd + " : "   + t.portRange[0] + "-" + t.portRange[1]);

        // lists to populate
        List<IPOperations<Future<PortStatus>>> futureList1 = new ArrayList<>();
        List<IPOperations<PortStatus>> resultList1 = new ArrayList<>();

        // ExecutorService

        try {
            long start = IPOperations.ipToLong(InetAddress.getByName(t.targetIP));
            long end = IPOperations.ipToLong(InetAddress.getByName(t.targetIPEnd));
            //System.out.println(IPOperations.compareIPs(t.targetIPEnd,t.targetIP));

        // loop through provided port range
            for (long current = start ; current<=end;current++){
                ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);

                List<Future<PortStatus>> futureListPerIp = new ArrayList<>();
                for (int currPort = t.portRange[0]; currPort <= t.portRange[1]; currPort++) {
                    futureListPerIp.add(PortScanner.isPortOpen(es, IPOperations.longToIp(current), currPort, SCAN_TIMEOUT));
                }
                IPOperations ip=new IPOperations(IPOperations.longToIp(current),futureListPerIp);
                futureList1.add(ip);


                es.shutdown();
                try {
                    if (!es.awaitTermination(2, TimeUnit.MINUTES)) {
                        // timeout elapsed before termination
                        es.shutdownNow();
                    }
                } catch (InterruptedException e) {
                    es.shutdownNow();
                }
            }

        } catch (UnknownHostException e) {
            e.printStackTrace();
        }


        for (IPOperations<Future<PortStatus>> IP : futureList1) {
            List<PortStatus> ls=new ArrayList<>();
            for (Future<PortStatus>  eachFuturePerIp:IP.portsStatus) {
                try {
                    ls.add(eachFuturePerIp.get(2,TimeUnit.MINUTES));
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                } catch (ExecutionException e) {
                    throw new RuntimeException(e);
                } catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                IPOperations ip=new IPOperations(IP.Ip,ls);
                resultList1.add(ip);
            } catch (Exception e) {
                System.err.println("Timeout reached");
                System.exit(1);
            }
        }






        // display results
        //PortScannerResult r = new PortScannerResult(resultList,t.targetIP ,t.targetIPEnd);
        PortScannerResult r = new PortScannerResult(resultList1,t.targetIP ,t.targetIPEnd);
        System.out.println(r);
    }

}