package org.example;

import junit.framework.TestCase;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParserTest {

    private ArrayList<String> userArgs;

    private static final String SAMPLE_IP_ADDR = "123.123.123.123";
    private static final String SAMPLE_IP_ADDR2 = "127.0.0.1";
    private String[] getUserArgs() {
        return this.userArgs.toArray(new String[this.userArgs.size()]);
    }

    private Target getExpectedTarget(String IP,String IPEnd, int portStart, int portEnd) {
        Target expectedTargetStruct = new Target();
        expectedTargetStruct.portRange[0] = portStart;
        expectedTargetStruct.portRange[1] = portEnd;
        expectedTargetStruct.targetIP = IP;
        expectedTargetStruct.targetIPEnd = IPEnd;
        return expectedTargetStruct;
    }

    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        userArgs = new ArrayList<>();
    }

//    test ip

//edit to test single ip
@Test
public void testValidCaseWithSingleIP() {
    Target exp = getExpectedTarget(SAMPLE_IP_ADDR, SAMPLE_IP_ADDR,22, 22);
    Target act = null;
    userArgs.add(SAMPLE_IP_ADDR);
    userArgs.add("22");

    try {
        act = Parser.run(getUserArgs());
        assertTrue(Arrays.equals(exp.portRange, act.portRange));
        assertEquals(exp.targetIP, act.targetIP);
        assertEquals(exp.targetIPEnd, act.targetIPEnd);
    } catch (Exception e) {
        fail("Unexpected exception :(");
    }
}

    @Test
    public void testInvalidIPRangeMultipleDashes() throws InvalidUserInputException {
        // expects exception too
        exceptionRule.expect(InvalidUserInputException.class);
        exceptionRule.expectMessage("Invalid user input: ip");

        // user input multiple dashes for port range
        userArgs.add(SAMPLE_IP_ADDR+"--"+SAMPLE_IP_ADDR2);
        userArgs.add("14-15");
        Parser.run(getUserArgs());
    }

//    test ports
//    edit to test valid case with IP range
    @Test
    public void testValidCaseWithPortRange() {
        Target exp = getExpectedTarget(SAMPLE_IP_ADDR,SAMPLE_IP_ADDR2 ,14, 23);
        Target act = null;
        userArgs.add(SAMPLE_IP_ADDR+"-"+SAMPLE_IP_ADDR2);
        userArgs.add("14-23");

        try {
            act = Parser.run(getUserArgs());
            // assertEquals(exp.portRange, act.portRange);
            assertTrue(Arrays.equals(exp.portRange, act.portRange));
            assertEquals(exp.targetIP, act.targetIP);
            assertEquals(exp.targetIPEnd, act.targetIPEnd);
        } catch (Exception e) {
            fail("Unexpected exception :(");
        }
    }

    @Test
    public void testValidCaseWithSinglePort() {
        Target exp = getExpectedTarget(SAMPLE_IP_ADDR, SAMPLE_IP_ADDR2,22, 22);
        Target act = null;
        userArgs.add(SAMPLE_IP_ADDR+"-"+SAMPLE_IP_ADDR2);
        userArgs.add("22");

        try {
            act = Parser.run(getUserArgs());
            assertTrue(Arrays.equals(exp.portRange, act.portRange));
            assertEquals(exp.targetIP, act.targetIP);
            assertEquals(exp.targetIPEnd, act.targetIPEnd);
        } catch (Exception e) {
            fail("Unexpected exception :(");
        }
    }

    @Test
    public void testMissingIPInput() throws InvalidUserInputException {
        // expects exception
        exceptionRule.expect(InvalidUserInputException.class);
        exceptionRule.expectMessage("Invalid user input");

        // user only input port range
        userArgs.add("14-23");
        Parser.run(getUserArgs());
    }

    @Test
    public void testInvalidPortRangeAlphanumericInput() throws InvalidUserInputException {
        // expects exception
        exceptionRule.expect(InvalidUserInputException.class);
        exceptionRule.expectMessage("Invalid user input: port");

        // user input alphanumeric port range
        userArgs.add(SAMPLE_IP_ADDR+"-"+SAMPLE_IP_ADDR2);
        userArgs.add("24a-d3f");
        Parser.run(getUserArgs());
    }

    @Test
    public void testInvalidPortRangeMultipleDashes() throws InvalidUserInputException {
        // expects exception too
        exceptionRule.expect(InvalidUserInputException.class);
        exceptionRule.expectMessage("Invalid user input: port");

        // user input multiple dashes for port range
        userArgs.add(SAMPLE_IP_ADDR+"-"+SAMPLE_IP_ADDR2);
        userArgs.add("14--15");
        Parser.run(getUserArgs());
    }

    @Test
    public void testValidPortRangeAllPorts() {
        Target exp = getExpectedTarget(SAMPLE_IP_ADDR, SAMPLE_IP_ADDR2,1, 65535);
        Target act = null;
        userArgs.add(SAMPLE_IP_ADDR+"-"+SAMPLE_IP_ADDR2);

        try {
            act = Parser.run(getUserArgs());
            assertArrayEquals(exp.portRange, act.portRange);
            assertEquals(exp.targetIP, act.targetIP);
        } catch (Exception e) {
            fail("Unexpected Exception :O");
        }
    }
}