package org.example;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Future;

public class IPOperations<T>  {

    String Ip;
    List<T> portsStatus;
    public  IPOperations(String ip,List<T> portsStatus){
        this.Ip=ip;
        this.portsStatus=portsStatus;
    }
    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0;
        for (byte octet : octets) {
            result <<= 8;
            result |= octet & 0xFF;
        }
        return result;
    }
    public static String longToIp(long ip) {
        return String.format("%d.%d.%d.%d",
                (ip >> 24) & 0xFF,
                (ip >> 16) & 0xFF,
                (ip >> 8) & 0xFF,
                ip & 0xFF);
    }
    public static long compareIPs(String ip1, String ip2) {
        // Compare two IP addresses
        try {
            return ( ipToLong(InetAddress.getByName(ip1)) - ipToLong(InetAddress.getByName(ip2)) );
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

}
