package org.example;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.net.InetAddress;
public final class PortScannerResult {
//    private String startIp;
//    private String endIP;
    private List<IPOperations> openList;
    private List<IPOperations> closedList;


    public PortScannerResult(List<IPOperations<PortStatus>> resultList,String start , String end) {
        this.openList = new ArrayList<>();
        this.closedList = new ArrayList<>();
//        startIp=start;
//        endIP=end;

        for (IPOperations<PortStatus> eachPortsStatusList : resultList) {
            List<PortStatus> openListPerIP = new ArrayList<>();
            List<PortStatus> closedListPerIP = new ArrayList<>();
            for (PortStatus eachPortStatus:eachPortsStatusList.portsStatus) {

                if (eachPortStatus.getIsOpen()) {
                    openListPerIP.add(eachPortStatus);
                } else {
                    closedListPerIP.add(eachPortStatus);
                }
            }
                IPOperations ipOpenPorts=new IPOperations(eachPortsStatusList.Ip,openListPerIP);
                IPOperations ipColsedPorts=new IPOperations(eachPortsStatusList.Ip,closedListPerIP);
                openList.add(ipOpenPorts);
                closedList.add(ipColsedPorts);
        }
    }

    @Override
    public String toString() {
        List<StringBuilder> sbs=new ArrayList<>();
        StringBuilder sb = new StringBuilder();



        int totalCount = openList.get(0).portsStatus.size() + closedList.get(0).portsStatus.size();

        for (IPOperations<PortStatus> openPortStatusPerIP : openList) {

            sb.append("ip  : " + openPortStatusPerIP.Ip  + "\n");
            sb.append(openPortStatusPerIP.portsStatus.size() + "/" + totalCount + " were open\n");

            for (PortStatus openPortStatus:openPortStatusPerIP.portsStatus) {
                sb.append(openPortStatus + "\n");
            }
//            try {
//            startIp=  IPOperations.longToIp(IPOperations.ipToLong(InetAddress.getByName(startIp)) + 1)  ;
//            } catch (UnknownHostException e) {
//                throw new RuntimeException(e);
//            }
        }
        return sb.toString();
    }
}
