import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.example.PrimeNumberExtractor;

public class PrimeNumberTest extends TestCase
{
    public void testPrime ()
    {
        long startTime = System.currentTimeMillis();
        PrimeNumberExtractor primeNumberExtractor = new PrimeNumberExtractor();
        List<Integer> results = new ArrayList<>();
        List<Thread> threads = new ArrayList<>();

        int numThreads = 4;
        int rangeSize = 100000000 / numThreads;

        // Create and start worker threads
        for (int i = 0; i < numThreads; i++) {
            int start = i * rangeSize;
            int end = (i + 1) * rangeSize;
            Thread thread = new Thread(() -> primeNumberExtractor.extractPrimes(start, end, results));
            thread.start();
            threads.add(thread);
        }

        // Wait for all worker threads to finish
        for (Thread thread : threads) {
            try {
                thread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;


        int totalCount = 0;
        for (int count : results) {

            totalCount += count;
        }

        double executionTimeSeconds = (double) executionTime / 1000.0;

        System.out.println("Total Number of Prime Numbers: " + (totalCount - 2));
        System.out.println("Execution Time: " + executionTimeSeconds + " seconds");

    }

}
