import junit.framework.TestCase;
import java.util.ArrayList;
import java.util.List;

public class StudentServiceTest extends TestCase {

    public void testStudentService()
    {
        long StartTime= System.currentTimeMillis();
        Student student = new Student("Mhd");
        StudentService svc = new StudentService();
        svc.SaveStudent(student);
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testMultiStudentService()
    {
        long StartTime= System.currentTimeMillis();
        StudentService svc = new StudentService();

        for (int i=0; i<10;i++) {
            Student student = new Student("Mhd "+i);
            svc.SaveStudent(student);
        }
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testStudentServiceUsingThread()
    {

        long StartTime= System.currentTimeMillis();
        System.out.println("The name of the current name is: "+ Thread.currentThread().getName());
        StudentService svc = new StudentService();
        Student student = new Student("Mhd");
        StudentServiceThread studentServiceThread = new StudentServiceThread(svc,student);
        studentServiceThread.setName("MyTestThread");
        studentServiceThread.start();
//        studentServiceThread.run();
        try {
            studentServiceThread.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testStudentServiceUsingThreadsNotReally()
    {
        long StartTime= System.currentTimeMillis();
        StudentService svc = new StudentService();
        for (int i= 0; i<10;i++) {
            Student student = new Student("Mhd "+i);
            StudentServiceThread studentServiceThread = new StudentServiceThread(svc, student);
            studentServiceThread.setName("MyTestThread"+i);
            studentServiceThread.start();
            try {
                studentServiceThread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
//        studentServiceThread.run();

        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testStudentServiceUsingThreads()
    {
        long StartTime= System.currentTimeMillis();
        StudentService svc = new StudentService();
        List<StudentServiceThread> studentServiceThreadList = new ArrayList<>();

        for (int i= 0; i<10;i++) {
            Student student = new Student("Mhd "+i);
            StudentServiceThread studentServiceThread = new StudentServiceThread(svc, student);
            studentServiceThread.setName("MyTestThread"+i);
            studentServiceThread.start();
            studentServiceThreadList.add(studentServiceThread);

        }
//        studentServiceThread.run();

        for(StudentServiceThread studentServiceThread: studentServiceThreadList){
            try {
                studentServiceThread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testStudentServiceUsingRunnable()
    {

        StudentService studentService = new StudentService();
        Student student = new Student("Mhd");

        StudentServiceRunnable studentServiceRunnable = new StudentServiceRunnable(studentService,student);
        Thread th = new Thread(studentServiceRunnable);
        th.start();
        try {
            th.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void testStudentServiceUsingAnonymousRunnable()
    {

        StudentService studentService = new StudentService();
        Student student = new Student("Mhd");

//        StudentServiceRunnable studentServiceRunnable = new StudentServiceRunnable(studentService,student);
        Thread th = new Thread(new Runnable() {
            @Override
            public void run() {
                studentService.SaveStudent(student);
            }
        });
        th.start();
        try {
            th.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void testStudentServiceUsingLambdaRunnable()
    {

        StudentService studentService = new StudentService();
        Student student = new Student("Mhd");

//        StudentServiceRunnable studentServiceRunnable = new StudentServiceRunnable(studentService,student);
        Thread th = new Thread(() -> studentService.SaveStudent(student));
        th.start();
        try {
            th.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
