import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;

public class PrimeNumTest extends TestCase {

    public void testFindPrimesSeq()
    {
        PrimeFinder primeFinder = new PrimeFinder(1, 100_000_000);
        long startTime = System.currentTimeMillis();
        List<Integer> Primes1 = primeFinder.getPrimes();
        long end = System.currentTimeMillis() -startTime;

        System.out.println("Time Taken = " + end);
        System.out.println(Primes1.size());

        assertEquals(5761456, Primes1.size());
    }

    public void testChunksRange(){
            int[] rangeLength = {100_000_000, 10_000_000, 1_000_000};
            int[] NumThreads = {1,2,3,4,5,6,7,8,9,10,20,30,40};

            for(int rl: rangeLength){
                for(int nt : NumThreads){
                    System.out.printf("Range Length: %-9d, NumThread: %d \n",rl,nt);

                    List<Thread> primeTh = new ArrayList<>();
                    for (int n = 0; n < nt; ++n) {
                        int start = getChunkStart(n, nt, rl);
                        int end = getChunkEnd(n, nt, rl);
                        System.out.println(start+ " "+ end);
                    }
                }
            }
        }

    public void testFindPrimesThread(){
        int[] rangeLength = {100_000_000, 10_000_000, 1_000_000};
        int[] NumThreads = {1,2,3,4,5,6,7,8,9,10,20,40,100,200,500,1000};

        for(int rl: rangeLength){
            for(int nt : NumThreads){
                System.out.printf("Range Length: %-9d, NumThread: %d \n",rl,nt);

                List<Thread> primeTh = new ArrayList<>();
                for (int n = 0; n < nt; ++n) {
                    int start = getChunkStart(n, nt, rl);
                    int end = getChunkEnd(n, nt, rl);
                    PrimeFinder primeFinder = new PrimeFinder(start, end);
                    Thread th = new Thread(() -> primeFinder.getPrimes());
                    primeTh.add(th);
                }

                long StartTime= System.currentTimeMillis();

                for(Thread primeFinderTh : primeTh){
                    primeFinderTh.start();
                }

                for(Thread primeFinderTh : primeTh){
                    try {
                        primeFinderTh.join();
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                long end = System.currentTimeMillis()- StartTime;
                System.out.println("Time Taken: "+ end);

            }
        }
    }

    private static int getChunkSize(final int nChunks, final int nElements) {
        return (nElements + nChunks - 1) / nChunks;
    }

    private static int getChunkStart(final int chunk,
                                              final int nChunks, final int nElements) {
        final int chunkSize = getChunkSize(nChunks, nElements);
        return (chunk * chunkSize)+1;
    }
    private static int getChunkEnd(final int chunk, final int nChunks,
                                            final int nElements) {
        final int chunkSize = getChunkSize(nChunks, nElements);
        final int end = (chunk + 1)  * chunkSize;
        if (end > nElements) {
            return nElements;
        } else {
            return end;
        }
    }


}
