import junit.framework.TestCase;

public class StudentServiceTest extends TestCase {

    public void testStudentService()
    {
        long StartTime= System.currentTimeMillis();
        Student student = new Student("Mhd");
        StudentService svc = new StudentService();
        svc.SaveStudent(student);
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testMultiStudentService()
    {
        long StartTime= System.currentTimeMillis();
        StudentService svc = new StudentService();

        for (int i=0; i<10;i++) {
            Student student = new Student("Mhd "+i);
            svc.SaveStudent(student);
        }
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }

    public void testStudentServiceUsingThread()
    {

        long StartTime= System.currentTimeMillis();
        System.out.println("The name of the current name is: "+ Thread.currentThread().getName());
        StudentService svc = new StudentService();
        Student student = new Student("Mhd");
        StudentServiceThread studentServiceThread = new StudentServiceThread(svc,student);
        studentServiceThread.setName("MyTestThread");
        studentServiceThread.start();
//        studentServiceThread.run();
        try {
            studentServiceThread.join();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long end = System.currentTimeMillis()- StartTime;

        System.out.println("Time Taken: "+ end);
    }
}
