#include <stdio.h>
#include <omp.h>

#define NUM_RECTANGLES 1000000

int main() {
    double total_area = 0.0;
    double width = 1.0 / NUM_RECTANGLES;

    #pragma omp parallel for reduction(+:total_area)
    for (int i = 0; i < NUM_RECTANGLES; i++) {
        double x = (i + 0.5) * width; // Midpoint of the rectangle
        double height = x * x;
        double area = width * height;
        total_area += area;
    }

    printf("Total area under the curve: %f\n", total_area);

    return 0;
}
 
