#include <mpi.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>  
#include <stdbool.h>
#include <unistd.h>


#include <mpi.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdbool.h>

void reduce_tree(int* send_data, int* recv_data, int count, MPI_Comm communicator) {
    int my_rank, com_size;
    MPI_Comm_rank(communicator, &my_rank);
    MPI_Comm_size(communicator, &com_size);

    // Determine the parent and children ranks in the virtual tree
    int parent_rank = (my_rank - 1) / 2;
    int left_child_rank = 2 * my_rank + 1;
    int right_child_rank = 2 * my_rank + 2;
    
     if(my_rank){
      recv_data = (int*)malloc(count * sizeof(int));
    }
    
    memset(recv_data, 0, count * sizeof(int));
   
    // Allocate buffers for received data from children
    int* left_child_data = (int*)malloc(count * sizeof(int));
    int* right_child_data = (int*)malloc(count * sizeof(int));

    // Receive data from left child if it exists
    if (left_child_rank < com_size) {
        MPI_Recv(left_child_data, count, MPI_INT, left_child_rank, 0, communicator, MPI_STATUS_IGNORE);
        
        for (int i = 0; i < count; i++) {
        recv_data[i] = left_child_data[i] + recv_data[i];
    }   
    }

    // Receive data from right child if it exists
    if (right_child_rank < com_size) {
        MPI_Recv(right_child_data, count, MPI_INT, right_child_rank, 0, communicator, MPI_STATUS_IGNORE);
     
        for (int i = 0; i < count; i++) {
        recv_data[i] = right_child_data[i] + recv_data[i];
    }
    
  
    }
   
    // Combine data with own data (e.g., using addition)
    for (int i = 0; i < count; i++) {
        recv_data[i] = recv_data[i] + send_data[i];
    }

    // Send the result to the parent if not the root process
    if (my_rank != 0) {
        MPI_Send(recv_data, count, MPI_INT, parent_rank, 0, communicator);
        
    }

    // Free allocated memory
    free(left_child_data); 
    free(right_child_data);
}





void reduce_sequential(
    int* send_data,
    int* recv_data,
    int count,
    MPI_Comm communicator)
{
    int my_rank;
    int com_size;
    MPI_Comm_rank(communicator, &my_rank);
    MPI_Comm_size(communicator, &com_size);

    int* gather_buffer = NULL;
    if (my_rank == 0)
    {
        gather_buffer = (int*) calloc(count * com_size, sizeof(int));
    }

    MPI_Gather(send_data, count, MPI_INT, gather_buffer, count, MPI_INT, 0, communicator);
    
    if (my_rank == 0)
    {
        memset(recv_data, 0, count * sizeof(int));
        for (int p = 0; p < com_size; p++)
            for (int i = 0; i < count; i++)
                recv_data[i] += gather_buffer[count * p + i];
        free(gather_buffer);
    }
 
}



int main(int argc, char** args)
{

    MPI_Init(&argc, &args);
    int max_value = 10000000;
    int* recv_array_tree = NULL;
    int* recv_array_sequential = NULL;

    int my_rank;
    double sequential_time = 0.0;
    double tree_time = 0.0;
    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);

    for (int count = 100; count <= max_value; count *= 10) {
        if (my_rank == 0) {
            recv_array_tree = (int*) malloc(count * sizeof(int));
            recv_array_sequential = (int*) malloc(count * sizeof(int));
        }

        int* send_array = (int*) malloc(count * sizeof(int));
        for (int i = 0; i < count; i++)
            send_array[i] = my_rank;

        double time1 = 0.0;
        double time2 = 0.0;
        MPI_Barrier(MPI_COMM_WORLD);
        time1 -= MPI_Wtime();
        reduce_tree(send_array, recv_array_tree, count, MPI_COMM_WORLD);
        time1 += MPI_Wtime();
        tree_time = time1;

        MPI_Barrier(MPI_COMM_WORLD);
        time2 -= MPI_Wtime();
        reduce_sequential(send_array, recv_array_sequential, count, MPI_COMM_WORLD);
        time2 += MPI_Wtime();
        sequential_time = time2;

        if (my_rank == 0) {
            
            printf("\nsize of array : %d \n", count);
            printf("Processing time for reduce tree is: %lf\n", tree_time);
            printf("Processing time for reduce sequential is: %lf\n\n", sequential_time);
            printf("-------------------------------------------------------------\n\n");
            for (int i = 0; i < count; i++) {
                if (recv_array_tree[i] != recv_array_sequential[i]) {
                    printf("At index %i: reduce_tree is %i, reduce_sequential is %i\n",
                        i, recv_array_tree[i], recv_array_sequential[i]);
                }
            }
 
            free(recv_array_tree);
            free(recv_array_sequential);
        }
        
        free(send_array);
    }

    MPI_Finalize();
    return 0;
    
    
}


 
