package org.example;

import java.util.ArrayList;
import java.util.List;

public class PrimeNumberExtractor {
    private static boolean isPrime(int num) {
        if (num < 2) {
            return false;
        }
        for (int i = 2; i <= Math.sqrt(num); i++) {
            if (num % i == 0) {
                return false;
            }
        }
        return true;
    }

    private static void extractPrimes(int start, int end, List<Integer> results) {
        List<Integer> primes = new ArrayList<>();
        for (int num = start; num < end; num++) {
            if (isPrime(num)) {
                primes.add(num);
            }
        }
        synchronized (results) {
            results.addAll(primes);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        List<Integer> results = new ArrayList<>();
        List<Thread> threads = new ArrayList<>();

        // Define the ranges for each thread
        int[][] ranges = {{1, 25000000}, {25000000, 50000000}, {50000000, 75000000}, {75000000, 100000001}};

        // Create and start worker threads
        for (int[] range : ranges) {
            Thread thread = new Thread(() -> extractPrimes(range[0], range[1], results));
            thread.start();
            threads.add(thread);
        }

        // Wait for all worker threads to finish
        for (Thread thread : threads) {
            thread.join();
        }

        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;

        System.out.println("Prime numbers:");
        System.out.println(results);
        System.out.println();
        System.out.println("Execution time: " + executionTime + " milliseconds");
    }
}