package org.example;

import java.util.Arrays;
import java.util.List;

public class PrimeNumberExtractor {
    public void extractPrimes(int start, int end, List<Integer> results) {
        boolean[] isPrim = new boolean[end];
        Arrays.fill(isPrim, true);
        for (int i = 2 ; i * i < end; i++)
            if (isPrim[i])
                for (int j = i * i; j < end; j += i)
                    isPrim[j] = false;

        int count = 0;
        for (int i = start  ; i < end; i++)
            if (isPrim[i]) count++;

        synchronized (results) {
            results.add(count);
        }
    }
}

