package org.example;

import java.util.Arrays;
import java.util.List;

public class PrimeNumberExtractor {
    public void extractPrimes(int start, int end, List<Integer> results) {
        int n = end - start + 1;
        boolean[] isPrim = new boolean[end + 1];
        Arrays.fill(isPrim, true);

        for (int i = 2; i * i <= end; i++) {
            for (int j = Math.max(i * i, (start + i - 1) / i * i); j <= end; j += i) {
                isPrim[j] = false;
            }
        }

        int count = 0;
        for (int i = Math.max(start, 2); i <= end; i++) {
            if (isPrim[i]) {
                count++;
            }
        }

        synchronized (results) {
            results.add(count);
        }
    }

}



