package org.example;

import org.apache.zookeeper.*;
import org.apache.zookeeper.KeeperException;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LeaderElection implements Watcher {
    private static final String address = "192.168.56.115:2181";
    private static final int SESSION_TIMEOUT = 3000; //dead client
    private ZooKeeper zooKeeper = null;


    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.run();
    }

    public void connectToZookeeper() throws IOException {

        this.zooKeeper = new ZooKeeper(address, SESSION_TIMEOUT, this);

    }

    public void run() throws InterruptedException {
        synchronized (zooKeeper) {
            zooKeeper.wait();
        }
        zooKeeper.close();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None:
                if (watchedEvent.getState() == Event.KeeperState.SyncConnected) {
                    System.out.println("Successfully connected to ZooKeeper");
                } else if (watchedEvent.getState() == Event.KeeperState.Expired) {
                    System.out.println("ZooKeeper session expired. Shutting down the program.");
                    synchronized (zooKeeper) {
                        zooKeeper.notifyAll();
                    }
                } else if (watchedEvent.getState() == Event.KeeperState.Disconnected) {
                    System.out.println("Disconnected from ZooKeeper. Shutting down the program.");
                    synchronized (zooKeeper) {
                        zooKeeper.notifyAll();
                    }
                }
                break;
        }
    }
}
