/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class LeaderElection
implements Watcher {
    private static final String ADDRESS = "192.168.56.115:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final String ELECTION_NAMESPACE = "/election";
    private String currentZnodeName;
    private String leader;
    private ZooKeeper zooKeeper = null;

    private void volunteerForLeadership() throws InterruptedException, KeeperException {
        String znodePrefix = "/election/c_";
        String path = this.zooKeeper.create(znodePrefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.currentZnodeName = path.replace("/election/", "");
        System.out.println("Created znode: " + path);
    }

    private void electLeader() throws InterruptedException, KeeperException {
        List<String> children = this.zooKeeper.getChildren(ELECTION_NAMESPACE, false);
        Collections.sort(children);
        this.leader = children.get(0);
        if (this.currentZnodeName.equals(this.leader)) {
            System.out.println("I'm the leader");
            this.setLeaderData(this.currentZnodeName);
        } else {
            System.out.println("I'm not the leader, the leader is " + this.leader);
            int currentZnodeIndex = children.indexOf(this.currentZnodeName);
            String previousZnode = "/election/" + children.get(currentZnodeIndex - 1);
            this.zooKeeper.exists(previousZnode, this);
        }
    }

    private void setLeaderData(String znodeName) {
        String znodePath = "/election/" + znodeName;
        try {
            this.zooKeeper.setData(znodePath, ("The leader is " + znodeName).getBytes(), -1);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Error setting leader data", e);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        LeaderElection leaderElection = new LeaderElection();
        leaderElection.connectToZookeeper();
        leaderElection.volunteerForLeadership();
        leaderElection.electLeader();
        leaderElection.run();
    }

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ADDRESS, 3000, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
        this.zooKeeper.close();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                this.handleNoneEvent(watchedEvent);
                break;
            }
            case NodeDeleted: {
                this.handleNodeDeletedEvent(watchedEvent);
                break;
            }
            case NodeDataChanged: {
                this.handleNodeDataChangedEvent(watchedEvent);
            }
        }
    }

    private void handleNodeDeletedEvent(WatchedEvent watchedEvent) {
        String deletedZnodePath = watchedEvent.getPath();
        System.out.println("Znode deleted: " + deletedZnodePath);
        if (deletedZnodePath.equals("/election/" + this.leader)) {
            System.out.println("The deleted znode was the leader. Re-electing leader...");
            try {
                this.electLeader();
            }
            catch (InterruptedException | KeeperException e) {
                throw new RuntimeException("Error re-electing leader", e);
            }
        }
    }

    private void handleNodeDataChangedEvent(WatchedEvent watchedEvent) {
        String znodePath = watchedEvent.getPath();
        System.out.println("Znode data changed: " + znodePath);
        byte[] znodePathBytes = new byte[]{};
        try {
            System.out.println(" 1111111");
            znodePathBytes = this.zooKeeper.getData(znodePath, false, null);
            System.out.println("2222222222222");
            this.zooKeeper.setData("/election/" + this.currentZnodeName, znodePathBytes, -1);
            System.out.println("333333333333");
            String data = new String(znodePathBytes);
            System.out.println(data);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] concatenateData(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNoneEvent(WatchedEvent watchedEvent) {
        if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
            System.out.println("Successfully connected to ZooKeeper");
        } else {
            if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                System.out.println("ZooKeeper session expired. Shutting down the program.");
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    this.zooKeeper.notifyAll();
                }
            }
            if (watchedEvent.getState() == Watcher.Event.KeeperState.Disconnected) {
                System.out.println("Disconnected from ZooKeeper. Shutting down the program.");
                ZooKeeper zooKeeper = this.zooKeeper;
                synchronized (zooKeeper) {
                    this.zooKeeper.notifyAll();
                }
            }
        }
    }
}

