package com.example.UploadingFile_Server.interceptor;

import Uploading_Service.FileMetadata;
import com.example.UploadingFile_Server.Constant;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.*;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;

@GrpcGlobalServerInterceptor
public class FileUploadInterceptor implements ServerInterceptor {
    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        FileMetadata fileMetadata = null;
        if (metadata.containsKey(Constant.fileMetaDataKey)) {
            byte[] metaBytes = metadata.get(Constant.fileMetaDataKey);
            try {
                fileMetadata = FileMetadata.parseFrom(metaBytes);
            } catch (InvalidProtocolBufferException e) {
                Status status = Status.INTERNAL.withDescription("unable to create file metadata");
                serverCall.close(status, metadata);
            }
            Context context = Context.current().withValue(
                    Constant.fileMetaContext,
                    fileMetadata
            );
            return Contexts.interceptCall(context, serverCall, metadata, serverCallHandler);
        }
        return new ServerCall.Listener<ReqT>() {
        };
    }
}
