package interceptor;

import Uploading_Service.FileMetadata;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.*;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;

@GrpcGlobalServerInterceptor
public class UploadInterceptor implements ServerInterceptor {
    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        FileMetadata fileMetadata = null;
        if (metadata.containsKey(Metadata.Key.of("file-meta-bin", Metadata.BINARY_BYTE_MARSHALLER))) {
            byte[] metaBytes = metadata.get(Metadata.Key.of("file-meta-bin", Metadata.BINARY_BYTE_MARSHALLER));
            try {
                fileMetadata = FileMetadata.parseFrom(metaBytes);
            } catch (InvalidProtocolBufferException e) {
                Status status = Status.INTERNAL.withDescription("Error in creating file metadata");
                serverCall.close(status, metadata);
            }
            Context.Key<FileMetadata> fileMetaContext = Context.key("file-meta");
            Context context = Context.current().withValue(
                    fileMetaContext,
                    fileMetadata
            );
            return Contexts.interceptCall(context, serverCall, metadata, serverCallHandler);
        }
        return new ServerCall.Listener() {
        };
    }
}
