package Services;

import Store.FileStorage;
import Uploading_Service.*;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import net.devh.boot.grpc.server.service.GrpcService;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

@GrpcService
public class UploadFileService extends uploadingServiceGrpc.uploadingServiceImplBase {
    @Override
    public StreamObserver<FileUploadRequest> uploadFile(StreamObserver<FileUploadResponse> responseObserver) {
        Context.Key<FileMetadata> fileMetaContext = Context.key("file-meta");
        FileMetadata fileMetadata = fileMetaContext.get();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileStorage fileStorage = new FileStorage();
        return new StreamObserver<FileUploadRequest>() {
            @Override
            //Called when client sends data
            public void onNext(FileUploadRequest fileUploadRequest) {
                try {
                    fileUploadRequest.getFile().getContent()
                            .writeTo(byteArrayOutputStream);
                } catch (IOException e) {
                    responseObserver.onError(io.grpc.Status.INTERNAL
                            .withDescription("a problem occur in writing data: " + e.getMessage())
                            .asRuntimeException());
                }
            }

            @Override
            //Called when client sends error
            public void onError(Throwable throwable) {
                System.out.println(throwable.toString());
            }

            @Override
            //Called when client finish sending data
            public void onCompleted() {
                int allReceivedBytes = byteArrayOutputStream.size();
                try {

                    if (allReceivedBytes == fileMetadata.getContentLength()) {
                        fileStorage.write(fileMetadata.getFileNameWithType(), byteArrayOutputStream);
                        byteArrayOutputStream.close();

                    } else {
                        responseObserver.onError(Status.FAILED_PRECONDITION
                                .withDescription(String.format("there is an different between expected bytes %d and received %d ", fileMetadata.getContentLength(), allReceivedBytes))
                                .asRuntimeException());
                        return;
                    }
                } catch (IOException e) {
                    responseObserver.onError(io.grpc.Status.INTERNAL
                            .withDescription("There is a problem in saving data: " + e.getMessage())
                            .asRuntimeException());
                    return;
                }
                responseObserver.onNext(
                        FileUploadResponse
                                .newBuilder()
                                .setFileName(fileMetadata.getFileNameWithType())
                                .setUploadStatus(UploadStatus.SUCCESS)
                                .build()
                );
                responseObserver.onCompleted();

            }
        };
    }
}
