package org.example;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class Producer implements Runnable {

    // File to read lines from
    private String file;

    // Queue to store lines read from the file
    private LinkedBlockingQueue<String> linesQueue;

    // Constructor to initialize the file and linesQueue
    public Producer(String file, LinkedBlockingQueue<String> linesQueue) {
        this.file = file;
        this.linesQueue = linesQueue;
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
            // Read lines from the file until the end is reached
            String line;
            while ((line = reader.readLine()) != null) {
                // Put the line into the linesQueue, blocking if the queue is full
                linesQueue.put(line);
            }
        } catch (IOException | InterruptedException e) {
            // Print the exception stack trace for debugging purposes
            e.printStackTrace();
        }
    }
}
