package org.example;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class Writer {

    public static void main(String[] args) {
        // File paths
        String inputFile = "Input/input.txt";
        String outputFile = "Output/output.txt";

        // Number of consumer threads
        int numConsumers = 3;

        // Create a blocking queue to hold the lines read from the file
        LinkedBlockingQueue<String> linesQueue = new LinkedBlockingQueue<>();

        // Create a concurrent queue to store the processed results for each consumer
        ConcurrentLinkedQueue<String> processedResults = new ConcurrentLinkedQueue<>();

        // Create a producer thread to read lines from the file and put them into the linesQueue
        Producer producer = new Producer(inputFile, linesQueue);
        Thread producerThread = new Thread(producer);
        producerThread.start();

        // Create a thread pool with the specified number of consumers
        ExecutorService executor = Executors.newFixedThreadPool(numConsumers);

        // Submit consumer tasks to the thread pool
        for (int i = 0; i < numConsumers; i++) {
            Consumer consumer = new Consumer(linesQueue, processedResults);
            executor.submit(consumer);
        }

        // Wait for all consumer tasks to complete
        executor.shutdown();
        while (!executor.isTerminated()) {
            // Wait for termination
        }

        // Write the processed results to the output file
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile))) {
            for (String result : processedResults) {
                writer.write(result);
                writer.newLine();
            }
        } catch (IOException e) {
            // Print the exception stack trace for debugging purposes
            e.printStackTrace();
        }
    }
}
