package org.example;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Consumer implements Runnable {

    // Queue of lines before processing them
    private LinkedBlockingQueue<String> linesQueue;

    // Queue of lines after processing them
    private ConcurrentLinkedQueue<String> processedLines;

    // Constructor to initialize the queues
    public Consumer(LinkedBlockingQueue<String> linesQueue, ConcurrentLinkedQueue<String> processedLines) {
        this.linesQueue = linesQueue;
        this.processedLines = processedLines;
    }

    @Override
    public void run() {
        try {
            // Infinite loop for continuous processing
            while (true) {
                // Print the name of the current thread for debugging purposes
                System.out.println(Thread.currentThread().getName());

                // Retrieve a line from the linesQueue
                String line = linesQueue.poll();

                // Check if there are no more lines to process
                if (line == null) {
                    break; // Exit the loop if no more lines
                }

                // Convert each lowercase letter to uppercase and vice versa
                StringBuilder swappedString = new StringBuilder();
                for (char c : line.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        swappedString.append(Character.toLowerCase(c));
                    } else if (Character.isLowerCase(c)) {
                        swappedString.append(Character.toUpperCase(c));
                    } else {
                        swappedString.append(c);
                    }
                }

                // Offer the processed line to the processedLines queue
                processedLines.offer(swappedString.toString());
            }
        } catch (Exception e) {
            // Print the exception stack trace for debugging purposes
            e.printStackTrace();
        }
    }
}
