package Coordinator_Worker;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

public class Worker {
    private static final int PORT = 12363;
    private String nodeName;
    private String ipAddress;
    private String userName;
    public Worker(String fullPathNode) {
        this.nodeName = fullPathNode;
    }


    public static void startWorker()  {
        ServerSocket serverSocket = null;
        try {
            // Step 1: Set up server socket to listen for connections
            serverSocket = new ServerSocket(PORT);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        while (true) {
            try {
                System.out.println("Waiting Request");
                // Step 2: Accept connection from coordinator
                Socket coordinatorSocket = serverSocket.accept();

                // Step 3: Receive data from coordinator
                DataObject data = Communication.receiveData(coordinatorSocket);
                System.out.println("Received data from coordinator: " + data.getDataString() + ", " + data.getFileNames());

                // Step 4: Process the data using IDF algorithm
                ConcurrentLinkedQueue<Document> response = new ConcurrentLinkedQueue<>();
                response.addAll(IDF(data));

                // Step 5: Send the result back to the coordinator
                Communication.sendResult(coordinatorSocket, response);

                // Step 6: Close sockets
                coordinatorSocket.close();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }


    // Function to calculate IDF for each term in the search query across files
    private static ConcurrentLinkedQueue<Document> IDF(DataObject data) {
        ConcurrentLinkedQueue<Document> documents=new ConcurrentLinkedQueue<>();
        String searchQuery = data.getDataString();
        String[] terms = searchQuery.split("\\s+");

        // Step 2: Use ExecutorService for parallel processing
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

        try {
            for (String fileName : data.getFileNames()) {
                File file = new File("C:\\Users\\Abdullah\\Downloads\\network-communication-master\\Cordinator_Worker\\src\\main\\resources\\" + fileName);
                Runnable task = () -> processFile(file, terms,documents);
                executorService.submit(task);
            }
           executorService.awaitTermination(2, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        } finally {
            //Step 5: Shutdown the ExecutorService
            executorService.shutdown();
        }

        // Step 6: Return the final IDF map
        return documents;
    }

    // Function to process each file and calculate term frequencies
    private static void processFile(File file, String[] terms,ConcurrentLinkedQueue<Document>documents) {
        Document document = new Document(file.getName());
        double totalWords = 0;

        try {
            // Read content from the file
            String content = new String(Files.readAllBytes(file.toPath()));
            String[] words = content.split("\\s+");

            // Calculate term frequencies in the file
            for (String term : terms) {
                double frequency = 0;
                for (String word : words) {
                    if (word.equals(term)) {
                        frequency++;
                    }
                    totalWords++;
                }
                Double d= frequency/totalWords;
                document.setTf(term, d);
                documents.offer(document);
            }
        } catch (IOException e) {
            e.printStackTrace();
            // Handle file reading exception
        }
    }
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNodeName() {
        return nodeName;
    }

    public static List<String> getIpAddress(List<Worker> workers) {
        List<String> allAddress = new ArrayList<>();
        for (Worker worker : workers) {
            allAddress.add(worker.ipAddress);
        }
        return allAddress;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public String getUserName() {
        return userName;
    }
}
