package Coordinator_Worker;

import Zookeeper.ServiceRegistry;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.*;

public class Coordinator {
    private static final int PORT = 12363;

    public static void startCoordinator() {
        ConcurrentLinkedQueue<Document> workersResult = new ConcurrentLinkedQueue<>();
        try {
            String dataString = "the car";

            String[] parts = dataString.split("\\s");
            List<Term> terms = new ArrayList<>();
            for (String part : parts) {
                terms.add(new Term(part));
            }

            TreeMap<String, Double> response = new TreeMap<>();

            List<String> fileNames = getFileNamesInDirectory("src/main/resources");

            int eachWorkerFiles = fileNames.size() / ServiceRegistry.getWorkers().size();

            int mode = fileNames.size() % ServiceRegistry.getWorkers().size();

            int index = 0;

            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (Worker worker : ServiceRegistry.getWorkers()) {
                List<String> workerFilesList = new ArrayList<>();
                for (int i = 0; i < eachWorkerFiles; i++) {
                    workerFilesList.add(fileNames.get(index));
                    index++;

                    if (mode != 0) {
                        if (index != fileNames.size()) {
                            workerFilesList.add(fileNames.get(index));
                            index++;
                        }
                    }
                }
                // Connect to worker
                Socket workerSocket = new Socket("127.0.0.1", PORT);
                // Create a CoordinatorHandler instance for each worker
                Runnable task = () -> processRequest(workerSocket, workerFilesList, dataString, workersResult);
                // Start the CoordinatorHandler thread
                executorService.submit(task);
            }
            executorService.awaitTermination(5, TimeUnit.SECONDS);

            for (int i = 0; i < terms.size(); i++) {
                for (Document document : workersResult) {
                    Map<String, Double> tf = document.getTf();
                    if (tf.get(terms.get(i).getTermName()) > 0) ;
                    terms.get(i).increase();
                }
            }

            TreeMap<String, Double> IDF = new TreeMap<>();
            for (Document document : workersResult) {
                document.setTerms(terms);
                document.CalculateIDF(fileNames.size());
                IDF.put(document.getName(), document.getIDF());
            }
            System.out.println("IDF Files: " + IDF);
            executorService.shutdown();

        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }finally {

        }
    }

    public static List<String> getFileNamesInDirectory(String directoryPath) {
        try {
            // Create a Path object for the specified directory
            Path directory = Paths.get(directoryPath);

            // Use try-with-resources to open a DirectoryStream and iterate over the files
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory)) {
                // Create a list to store file names
                List<String> fileNames = new ArrayList<>();

                // Iterate over the files in the directory
                for (Path path : directoryStream) {
                    // Get the file name and add it to the list
                    fileNames.add(path.getFileName().toString());
                }

                // Return the list of file names
                return fileNames;
            }
        } catch (IOException e) {
            // Handle exceptions, e.g., directory not found
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static void processRequest(Socket clientSocket, List<String> fileNames,
                                       String dataString, ConcurrentLinkedQueue<Document> documents) {

        try {
            // Send data to worker
            Communication.sendData(clientSocket, dataString, fileNames);

            // Receive results from worker
            ConcurrentLinkedQueue<Document> d = Communication.receiveResult(clientSocket);
            documents.addAll(d);
            clientSocket.close();

        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

}
