package grpc.client;

import grpc.searchServiceGrpc;
import grpc.Request;
import grpc.Response;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.checkerframework.checker.units.qual.Time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class grpcClient implements Watcher {
    private static final String ELECTION_NAMESPACE = "/election";
    private ZooKeeper zooKeeper;
    private  String leaderIP;
    // Method to start the gRPC client
    public grpcClient(ZooKeeper zooKeeper) throws InterruptedException, KeeperException {
        this.zooKeeper = zooKeeper;
        this.getLeaderIP();
    }
    private void getLeaderIP() throws InterruptedException, KeeperException {
        List<String> children= zooKeeper.getChildren(ELECTION_NAMESPACE,this);
        Collections.sort(children);
        String leader = children.get(0);
        Stat state = zooKeeper.exists(ELECTION_NAMESPACE+"/"+leader,false);
        byte[] ipBytes= zooKeeper.getData(ELECTION_NAMESPACE+"/"+leader,false,state);
        leaderIP= new String(ipBytes);
    }

    public Map<String,Double> startClient(String searchQuery) {

        // Step 1: Create a gRPC channel to connect to the server
        ManagedChannel channel = ManagedChannelBuilder.forAddress(leaderIP, 8080)
                .usePlaintext()  // For simplicity, using plaintext communication. In production, consider using TLS.
                .build();

        // Step 2: Create a blocking stub for the search service
        searchServiceGrpc.searchServiceBlockingStub searchServiceStub = searchServiceGrpc.newBlockingStub(channel);

        // Step 3: Create a request with the input string
        Request request = Request.newBuilder().setInput(searchQuery).build();

        // Step 4: Make the RPC call and receive the response
        Response response = searchServiceStub.search(request);
        TreeMap<String,Double> result= new TreeMap<>(new Comparator<String>() {
            @Override
            public int compare(String key1, String key2) {
                int valueCompare = response.getOutputMap().get(key2).compareTo(response.getOutputMap().get(key1));
                return (valueCompare == 0) ? key1.compareTo(key2) : valueCompare;
            }
        });;
        result.putAll(response.getOutputMap());
        // Step 5: Process the response

        // Get the current date and time
        LocalDateTime currentTime = LocalDateTime.now();

        // Format the date and time if needed
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedTime = currentTime.format(formatter);

        System.out.println( formattedTime + "- Result gRPC= " + result);
        // Step 6: Shutdown the gRPC channel
        channel.shutdown();
        return result;
    }

    @Override
    public void process(WatchedEvent watchedEvent) {

    }
}
