package Coordinator_Worker;

import java.io.*;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Communication {

    // Method to send data to the specified socket
    public static void sendData(Socket socket, String dataString, List<String> fileNames) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());

        // Create and send a DataObject containing dataString and fileNames
        objectOutputStream.writeObject(new DataObject(dataString, fileNames));
    }

    // Method to receive a result as a ConcurrentLinkedQueue<Document> from the specified socket
    public static ConcurrentLinkedQueue<Document> receiveResult(Socket socket) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());

        // Read and return the result as a ConcurrentLinkedQueue<Document>
        return (ConcurrentLinkedQueue<Document>) objectInputStream.readObject();
    }

    // Method to receive a DataObject from the specified socket
    public static DataObject receiveData(Socket socket) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());

        // Read and return the received DataObject
        return (DataObject) objectInputStream.readObject();
    }

    // Method to send a ConcurrentLinkedQueue<Document> as a result to the specified socket
    public static void sendResult(Socket socket, ConcurrentLinkedQueue<Document> response) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());

        // Send the result as a ConcurrentLinkedQueue<Document>
        objectOutputStream.writeObject(response);
    }
}
