/*
 * Decompiled with CFR 0.152.
 */
package grpc.server;

import Coordinator_Worker.Coordinator;
import grpc.Request;
import grpc.Response;
import grpc.searchServiceGrpc;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class grpcServer {
    public static void startGrpcServer() throws Exception {
        System.out.println("Starting gRPC Server");
        Server server = ServerBuilder.forPort((int)8080).addService((BindableService)new SearchServiceImpl()).executor((Executor)Executors.newFixedThreadPool(10)).build();
        server.start();
        server.awaitTermination();
    }

    private static class SearchServiceImpl
    extends searchServiceGrpc.searchServiceImplBase {
        private SearchServiceImpl() {
        }

        @Override
        public void search(Request request, StreamObserver<Response> responseObserver) {
            Executors.newCachedThreadPool().submit(() -> {
                try {
                    TreeMap<String, Double> IDF = Coordinator.startCoordinator(request.getInput());
                    Response.Builder responseBuilder = Response.newBuilder();
                    for (Map.Entry<String, Double> entry : IDF.entrySet()) {
                        responseBuilder.putOutput(entry.getKey(), entry.getValue());
                    }
                    Response response = responseBuilder.build();
                    System.out.println("Response gRPC is: " + response.getOutputMap());
                    responseObserver.onNext((Object)response);
                    responseObserver.onCompleted();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

