/*
 * Decompiled with CFR 0.152.
 */
package Zookeeper;

import Coordinator_Worker.Worker;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.LoggerFactory;

public class ServiceRegistry
implements Watcher {
    private static final String REGISTRY_ZNODE = "/service_registry";
    private final ZooKeeper zooKeeper;
    private String currentZnode = null;
    private static final Logger logger = (Logger)LoggerFactory.getLogger(ServiceRegistry.class);
    private static List<Worker> workers = new ArrayList<Worker>();

    public ServiceRegistry(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
        this.createServiceRegistryZnode();
    }

    private void createServiceRegistryZnode() {
        try {
            if (this.zooKeeper.exists(REGISTRY_ZNODE, false) == null) {
                this.zooKeeper.create(REGISTRY_ZNODE, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void registerToCluster(String metadata) throws KeeperException, InterruptedException {
        if (this.currentZnode != null) {
            logger.info("Already registered to service registry");
            return;
        }
        this.currentZnode = this.zooKeeper.create("/service_registry/n_", metadata.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        logger.info("Registered to service registry");
    }

    public void registerForUpdates() {
        try {
            this.updateAddresses();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void unregisterFromCluster() {
        try {
            if (this.currentZnode != null && this.zooKeeper.exists(this.currentZnode, false) != null) {
                this.zooKeeper.delete(this.currentZnode, -1);
            }
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void updateAddresses() throws KeeperException, InterruptedException {
        System.out.println("Enter");
        List<String> workerZnodes = this.zooKeeper.getChildren(REGISTRY_ZNODE, this);
        ArrayList<Worker> workerList = new ArrayList<Worker>();
        Thread.sleep(100L);
        for (String workerZnode : workerZnodes) {
            String workerFullPath = "/service_registry/" + workerZnode;
            Worker newWorker = new Worker(workerZnode);
            Stat stat = this.zooKeeper.exists(workerFullPath, false);
            if (stat == null) continue;
            byte[] addressBytes = this.zooKeeper.getData(workerFullPath, false, stat);
            String data = new String(addressBytes);
            String[] parts = data.split(",");
            String address = parts[0];
            newWorker.setIpAddress(address);
            newWorker.setUserName(parts[1]);
            workerList.add(newWorker);
        }
        System.out.println(workers);
        if (workers != null) {
            workers.removeAll(workers);
        }
        if (workerList != null) {
            workers.addAll(workerList);
        }
        logger.info("The cluster addresses are: " + Worker.getIpAddress(workers));
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        try {
            this.updateAddresses();
            System.out.println(workers);
            Thread.sleep(1000L);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Worker> getWorkers() {
        return workers;
    }
}

